#############################################################################
#############################################################################
#
# latexComm.tcl (called from latex.tcl)
#
#############################################################################
#
# Old Author:  Tom Scavo <trscavo@syr.edu>
# New Author:  Vince Darley <vince@santafe.edu>
#############################################################################
#############################################################################

proc latexComm.tcl {} {}
#--------------------------------------------------------------------------
# TeX applications
#--------------------------------------------------------------------------

# In the following scripts, $quotedSig and $filename are the application 
# signature and the name of the file to be typeset, respectively.  (See
# proc 'evalTeXScript' below.)
array set bibtexAppScripts {
    DirectTeXPro {
	{dosc -c $quotedSig -s  "ProjectMgr -t \$dt_TeXFormat	\"[win::Current]\"; MenuCommand 1 5"}
    } CMacTeX {
	{sendOpenEvent noReply $quotedSig $filename}
    } BibTeX {
	{sendOpenEvent noReply $quotedSig $filename}
    }
}
array set bibtexAppSignatures {
    CMacTeX CMTu BibTeX Vbib
}
array set dvipsAppScripts {
    DirectTeXPro {
	{dosc -c $quotedSig -s  "ProjectMgr -t \$dt_TeXFormat	\"[win::Current]\";  directory \$dt_TeXProjectDir > CurrDirectory; dvips \$dt_TeXProjectName"}
    } CMacTeX {
	{dosc -c $quotedSig -k 'aevt' -e 'odoc' -t 600 -f $filename}
    } OzTeX {
	{sendOpenEvent noReply $quotedSig $filename}
    }
}
array set dvipsAppSignatures {
    DirectTeXPro TeX+ CMacTeX CMT1 OzTeX OzDP
}
array set makeindexAppScripts {
    DirectTeXPro {
	{dosc -c $quotedSig -s  "ProjectMgr -t \$dt_TeXFormat	\"[win::Current]\"; MenuCommand 1 6"}
    } CMacTeX {
	{sendOpenEvent noReply $quotedSig $filename}
    } MakeIndex {
	{sendOpenEvent noReply $quotedSig $filename}
    }
}
array set makeindexAppSignatures {
    DirectTeXPro TeX+ CMacTeX CMTt MakeIndex RZMI
}
array set printDVIAppScripts {
    Textures {
	{AEBuild $quotedSig aevt pdoc "----" [makeAlis $filename]}
    } DirectTeXPro {
	{dosc -c $quotedSig -s  "ProjectMgr -t \$dt_TeXFormat	\"[win::Current]\"; MenuCommand 1 9"}
    } CMacTeX {
	{dosc -c $quotedSig -k 'aevt' -e 'pdoc' -r -f $filename}
    } OzTeX {
	{dosc -c $quotedSig -k 'aevt' -e 'pdoc' -r -f $filename}
    }
}
array set printDVIAppSignatures {
    Textures *TEX DirectTeXPro TeX+ CMacTeX CMT8 OzTeX OTEX
}
array set printPSAppScripts {
    DropPS {
	{dosc -c $quotedSig -k 'aevt' -e 'odoc' -r -f $filename}
    } DirectTeXPro {
	{dosc -c $quotedSig -s  "ProjectMgr -t \$dt_TeXFormat	\"[win::Current]\";  directory \$dt_TeXProjectDir > CurrDirectory; download \$dt_TeXProjectName.ps"}
    } CMacTeX {
	{dosc -c $quotedSig -k 'aevt' -e 'odoc' -r -f $filename}
    }
}
array set printPSAppSignatures {
    DropPS DPS DirectTeXPro TeX+ CMacTeX PSP*
}
array set texAppScripts {
    DirectTeX {
	{set script "Begin; ChangeTeXProject '$filename' -check -confirm || Exit 0;  Execute \"{dt_TeXProject}\"; TeXMenu -tex -formats;  End  Dev:Null; RunSession 1  Dev:Null"} 
	{dosc -r -c $quotedSig -s $script} 
    } Textures {
	{global Texturesconnections} 
	{set TeXjob ""} 
	{
	    if {[info exists Texturesconnections]} {
		foreach entry $Texturesconnections {
		    if {[car $entry] == $filename} {
			set TeXjob [lindex $entry 1]
			break
		    }
		}
	    }
	}   
	{
	    if { $TeXjob == "" } {
		set TeXjob [AEBuild -r $quotedSig BSRs Begi "----" [aebuild::alis $filename]]
		set TeXjob [string trim [string range $TeXjob 15 end] {\{\}\"}]
		lappend Texturesconnections [list $filename $TeXjob]
	    }
	}
	{if {[regexp "^%&\[^ \t\]*$" [getText [minPos] [set p [nextLineStart [minPos]]]]]} {
	set fmtname \[getText 2 [incr p -1]]\
        } else {
	set fmtname LaTeX
        }}
	{AEBuild -t 1200 $quotedSig BSRs Typf Fmat $fmtname Jobi $TeXjob} 
    } DirectTeXPro {
	{dosc -c $quotedSig -s  "if \$dt_TeXFormat = \'\' \"set dt_TeXFormat -x \$dt_DefaultFormat\""} 
	{dosc -c $quotedSig -s  "ProjectMgr -t \$dt_TeXFormat \"$filename\"; MenuCommand 1 4"} 
    } CMacTeX {
	{dosc -c $quotedSig -k 'aevt' -e 'odoc' -r -f $filename}
    } OzTeX {
	{sendOpenEvent noReply $quotedSig $filename}
    } 
}
array set texAppSignatures {
    DirectTeX MPS* Textures *TEX DirectTeXPro TeX+ 
    CMacTeX {*XeT BTxT pXeT} OzTeX OTEX
}
array set viewDVIAppScripts {
    Textures {
	{AEBuild $quotedSig aevt odoc "----" [makeAlis $filename]}
    } DirectTeXPro {
	{dosc -c $quotedSig -s "ProjectMgr -t \$dt_TeXFormat	\"[win::Current]\"; MenuCommand 1 8"}
    } CMacTeX {
	{dosc -c $quotedSig -k 'aevt' -e 'odoc' -r -f $filename}
    } OzTeX {
	{sendOpenEvent noReply $quotedSig $filename}
    }
}
array set viewDVIAppSignatures {
    Textures *TEX DirectTeXPro TeX+ CMacTeX {PIVD CMT8} OzTeX OTEX
}
array set viewPSAppScripts {
    CMacTeX {
	{dosc -c $quotedSig -k 'aevt' -e 'odoc' -r -f $filename}
    } MacGS {
	{dosc -c $quotedSig -k 'aevt' -e 'odoc' -r -f $filename}
    } Tailor {
	{dosc -c $quotedSig -k 'aevt' -e 'odoc' -r -f $filename}
    }
}
array set viewPSAppSignatures {
    CMacTeX {CMT5 CMTJ TMCJ} MacGS gsVR Tailor Tail
}
array set viewPDFAppScripts {
    CMacTeX {
	{dosc -c $quotedSig -k 'aevt' -e 'odoc' -r -f $filename}
    } MacGS {
	{dosc -c $quotedSig -k 'aevt' -e 'odoc' -r -f $filename}
    } Acrobat {
	{sendOpenEvent noReply $quotedSig $filename}
    }
}
array set viewPDFAppSignatures {
    MacGS gsVR Acrobat CARO CMacTeX CMTJ
}

#--------------------------------------------------------------------------
# Typeset submenu commands
#--------------------------------------------------------------------------

proc typeset {{bg 0}} {
    global texSig texAppSignatures TeXmodeVars

    set currentWin [win::Current]
    if {$TeXmodeVars(useNewerTexturesInterface)} {
	if {[info exists texAppSignatures(Textures)] && \
	  $texSig == $texAppSignatures(Textures)} {
	    evalTeXScript tex {TeX app} $currentWin $bg
	    return
	}
    }
    # Is there a window open?
    if { $currentWin == "" } {
	typesetFile "" $bg
	return
    }
    # Strip off trailing garbage (if any):
    regexp {(.*) <[0-9]+>} $currentWin dummy currentWin
    # Is the current window part of TeX fileset?
    set fset [isWindowInFileset $currentWin "tex"]
    if { $fset != "" } {
	if [dirtyFileset $fset] {
	    switch [askyesno -c "Save current TeX fileset?"] {
		"yes" {saveEntireFileset $fset}
		"no" {
		    # do nothing
		}
		"cancel" {return}
	    }
	}
	typesetFile [texFilesetBaseName $fset] $bg
	return
    }
    # Is the window untitled or dirty?
    global PREFS
    set currentDoc [file tail $currentWin]
    if { [set num [winUntitled]] } {
	switch [askyesno -c "Save \"$currentDoc\"?"] {
	    "yes" {
		if {[catch {set currentWin [saveAs "Untitled$num\.tex"]}]} {return}
	    }
	    "no" {
		set tmpFilename "Untitled$num\.tex"
		set text [getText [minPos] [maxPos]]
		if {![file exists [file join $PREFS tmp]]} { mkdir [file join $PREFS tmp] }
		set newDoc [file join $PREFS tmp $tmpFilename]
		file::writeAll $newDoc $text 1
		set currentWin $newDoc
	    }
	    "cancel" {return}
	}
    } elseif { [winDirty] } {
	switch [askyesno -c "Save \"$currentDoc\"?"] {
	    "yes" {save}
	    "no" {
		set text [getText [minPos] [maxPos]]
		if {![file exists [file join $PREFS tmp]]} { file mkdir [file join $PREFS tmp] }
		set newDoc [file join $PREFS tmp temp-$currentDoc]
		file::writeAll $newDoc $text 1
		set currentWin $newDoc
	    }
	    "cancel" {return}
	}
    }
    # Is the current window TeX-able?
    set ext [file extension $currentWin]
    if { [lsearch -exact {.tex .ltx .dtx .ins} $ext] < 0 } {
	typesetFile "" $bg
	return
    }
    typesetFile $currentWin $bg
}

proc typesetSelection {} {
    global PREFS TeX::tmpFile
    if { [isSelection] } { 
	watchCursor
	message "processing selection"
	set currentWin [win::Current]
	# Is the current window part of TeX fileset?
	set fset [isWindowInFileset $currentWin "tex"]
	if { $fset == "" } {
	    set pos1 [getPos]
	    if { [isInDocument] } {
		set pos2 [selEnd]
		if { [isInDocument] } {
		    # fall through
		} else {
		    beep
		    set msg "Selection not in document environment.  Continue?"
		    if { [askyesno $msg] == "no" } { return }
		}
	    } else {
		beep
		set msg "Selection not in document environment.  Continue?"
		if { [askyesno $msg] == "no" } { return }
		set pos2 [selEnd]
	    }
	    set body "\r[getText $pos1 $pos2]\r"
	    set searchText [getText [minPos] [maxPos]]
	} else {
	    set body "\r[getSelect]\r"
	    # Will not handle a base file that is open and dirty:
	    set searchText [buildFilecontents [texFilesetBaseName $fset]]
	}
	message "building temporary document"
	set pattern {(\\documentclass.*)\\begin\{document\}}
	if { ![regexp -- $pattern $searchText dummy preamble] } {
	    set preamble "\\documentclass\{article\}\r"
	}
	set rootFile [file rootname $currentWin]
	set tempFile "temp-[file tail $rootFile]"
	set auxFile $rootFile.aux
	if { [file exists $auxFile] } {
	    set latexDoc [buildFilecontents $auxFile $tempFile.aux]
	} else {
	    set latexDoc {}
	}
	append latexDoc $preamble [buildEnvironment "document" "" $body "\r"]
	set currentDir [file dirname $currentWin]
	set latexDoc [texResolveAll $latexDoc $currentDir]
	if {![file exists [file join $PREFS tmp]]} { file mkdir [file join $PREFS tmp] }
	set newFile [file join $PREFS tmp $tempFile.tex]
	file::writeAll $newFile $latexDoc 1
	set lineOffset [expr {[llength [split $latexDoc "\r"]] - [llength [split $body "\r"]] -2}]
	set TeX::tmpFile($newFile) [list selection $currentWin $lineOffset]
	typesetFile $newFile
    } else {
	beep
	message "no selection"
    }
}

proc typesetClipboard {} {
    global PREFS TeX::tmpFile
    set body "\r[getScrap]\r"
    set pat1 {\\begin\{document\}.*\\end\{document\}}
    set pat2 {\\documentclass}
    set preamble "\\documentclass\{article\}\r"
    # Check to see if there's a document environment:
    if {![regexp -- $pat1 $body]} {
	append text $preamble [buildEnvironment "document" "" $body "\r"]
    } else {
	# Check to see if there's a \documentclass command:
	if {![regexp -- $pat2 $body]} {
	    append text $preamble $body
	} else {
	    set text $body
	}
    }
    if {![file exists [file join $PREFS tmp]]} { file mkdir [file join $PREFS tmp] }
    set newFile [file join $PREFS tmp temp-noname\.tex]
    file::writeAll $newFile $text 1
    set currentWin $newFile
    set TeX::tmpFile($newFile) "clipboard"
    typesetFile $currentWin
}

# Typeset $filename, but perform no error-checking
#
proc typesetFile {filename {bg 0}} {
    if { $filename == "" } {
	set filename [getfile "Choose a file to typeset:"]
    }
    evalTeXScript tex {TeX app} $filename $bg
}

# Apply $op to a file with extension $ext.  (See latexMenu.tcl for
# many examples.)  If 'forcecurrent == 1', use the current window 
# even if it belongs to a TeX fileset.
#
proc doTypesetCommand {op ext {forcecurrent 0}} {
    if { [set filename [findAuxiliaryFile $ext $forcecurrent]] != "" } {
	if { $op == "open" } { 
	    edit -r -m -w $filename 
	} else {
	    $op${ext}File $filename
	}
    } else {
	beep
	alertnote "No $ext file found!"
    }
}

proc viewDVIFile {filename} {
    evalTeXScript viewDVI {DVI viewer} $filename
}

proc viewPDFFile {filename} {
    evalTeXScript viewPDF {PDF viewer} $filename
}

proc printDVIFile {filename} {
    evalTeXScript printDVI {DVI print driver} $filename
}

proc dvipsDVIFile {filename} {
    evalTeXScript dvips {DVI-to-PS filter} $filename
}

proc viewPSFile {filename} {
    if {[catch {evalTeXScript viewPS {PS viewer} $filename}]} {
	message "View aborted."
    }
}

proc printPSFile {filename} {
    evalTeXScript printPS {PS print driver} $filename
}

proc bibtexAUXFile {filename} {
    evalTeXScript bibtex {BibTeX app} $filename
}

proc makeindexIDXFile {filename} {
    evalTeXScript makeindex {MakeIndex app} $filename
}

proc makeindexGLOFile {filename} {
    evalTeXScript makeindex {MakeIndex app} $filename
}

proc evalTeXScript {op prompt filename {runAppInBackground 0}} {
    global showTeXLog
    if {[info exists showTeXLog]} {
	app::runScript $op $prompt $filename $runAppInBackground $showTeXLog
    } else {
	app::runScript $op $prompt $filename $runAppInBackground 0
    }
    # this code needs a mechanism for waiting for the TeX run to complete
    if {0 && !$runAppInBackground && ($showTeXLog == 2)} {
	set fname [file tail $filename]
	set curr [file tail [win::Current]]
	if {[file extension $curr] == ".log" && ([file root $fname] == [file root $curr])} {
	    return
	} else {
	    set fname [file root $filename]
	    file::openQuietly ${fname}.log
	}
    }
}

# Two bugs in 'getfile' (see "alpha.bugs58"):
proc openAnyTeXFile {} {
    set	filename [getfile "" [win::Current]]
    if { ![string length $filename] } return
    edit -r -m -w $filename
}

proc removeAuxiliaryFiles {} {
    set word ""
    set removeSilently 0
    set currentWin [win::Current]
    if { $currentWin == "" } { return }
    set currentDir [file dirname $currentWin]
    set extensions {.ps .dvi .log .aux .bbl .idx .ind .glo .gls \
      .toc .lof .lot .blg .ilg}
    foreach ext $extensions {
	message "Checking for *$ext files"
	set files [glob -nocomplain -dir $currentDir *$ext]
	foreach file $files {
	    set word " more"
	    if {$removeSilently} {
		if {[catch {rm [file join $currentDir *$ext]}]} {
		    alertnote "not all \"*$ext\" files deleted"
		}
		break
	    } else {
		message ""
		set filename [file tail $file]
		switch [buttonAlert "Remove \"$filename\"?" "yes" "no" {rm ext} {rm all} "cancel"] {
		    "yes" {
			message "Removing $filename"
			if {[catch {removeFile [file join $currentDir $filename]}]} {
			    alertnote "\"$filename\" not deleted"
			} else {
			    message $filename
			}
		    }
		    "no" {}
		    "rm ext" {
			if {[catch {rm [file join $currentDir *$ext]}]} {
			    alertnote "not all \"*$ext\" files deleted"
			}
			break
		    }
		    "rm all" {
			if {[catch {rm [file join $currentDir *$ext]}]} {
			    alertnote "not all \"*$ext\" files deleted"
			}
			set removeSilently 1
			break
		    }
		    "cancel" {return}
		}
	    }
	}
    }
    message "No$word files found"
}

#--------------------------------------------------------------------------
# Utility procs:
#--------------------------------------------------------------------------

# Find a LaTeX auxiliary file with extension $ext.  If 'forcecurrent' 
# is true, search the current directory without checking for TeX filesets.
#
proc findAuxiliaryFile {ext {forcecurrent 0}} {
    
    set currentWin [win::Current]
    if { $currentWin == "" } { return "" }
    set currentDoc [file tail $currentWin]
    
    if {$forcecurrent} {
	# pretend there are no TeX filesets:
	set fset ""
    } else {
	set fset [isWindowInFileset $currentWin "tex"]
    }
    
    if { $fset != "" } {
	
	set currentWin [texFilesetBaseName $fset]
	set currentDoc [file tail $currentWin]
	set currentDir [file dirname $currentWin]
	set docBasename [file rootname $currentDoc]
	set lowerExt [string tolower $ext]
	
    } else {
	
	# we do all this if it's not a project:
	set currentDir [file dirname $currentWin]		
	set docBasename [file rootname $currentDoc]
	set lowerExt [string tolower $ext]
	
	# Is the window untitled or dirty?
	global PREFS
	if { [set num [winUntitled]] } {
	    set filename [file join $PREFS tmp Untitled$num\.$lowerExt]
	    if { [file exists $filename] } {
		return $filename
	    } else {
		return ""
	    }
	} elseif { [winDirty] } {
	    switch [askyesno "Window dirty---continue anyway?"] {
		"yes" {
		    set filename [file join $PREFS tmp temp-$currentDoc\.$lowerExt]
		    if { [file exists $filename] } {
			return $filename
		    } else {
			# fall through
		    }
		}
		"no" {return ""}
	    }
	}
    }
    
    # Check the current directory:
    set filename [file join $currentDir $docBasename\.$lowerExt]
    if { [file exists $filename] } {
	return $filename
    } else {
	return ""
    }
}

# If the current window is untitled, return its number (i.e., either
# the number 1 or the number  n  in "Untitled <n>"); otherwise, return 0.
proc winUntitled {} {
    set currentWin [win::Current]
    if { $currentWin == "" } { return 0 }
    set currentDoc [file tail $currentWin]
    if { [string match $currentWin $currentDoc] } {
	if { [regexp {<(.*)>} $currentDoc dummy num] } {
	    return $num
	} else {
	    return 1
	}
    } else {
	return 0
    }
}

## 
 # -------------------------------------------------------------------------
 # 
 # "texApp" --
 # 
 #  Switch to bibtex, latex or makeindex
 # -------------------------------------------------------------------------
 ##
proc texApp {name} {
    set type [string tolower $name]
    global ${type}Sig ${type}AppSignatures
    set supportedApps [array names ${type}AppSignatures]
    foreach app $supportedApps { eval lappend sigs [set ${type}AppSignatures($app)] }
    set longPrompt "Please locate your ${name} app."
    if { [catch {app::launchAnyOfThese $sigs ${type}Sig $longPrompt} appname] } {
	error "bug in 'app::launchAnyOfThese'"
    }
    set quotedSig "'[string trim [set ${type}Sig] {'}]'"
    switchTo $quotedSig
}









